define(['underscore', 'backbone'], function(_, Backbone) {
    'use strict';

    return Backbone.Model.extend({
        defaults: {
            url: '',
            messageText: '',
            messageDateTime: '',
            AppointmentRequestId: '',
            senderId: '',
            isLastMessage: true,
            messageSent: true,
        },
        isVetMessage: function() {
            return this.get('messageSent');
        },

        saveMessage: function(message, request, userId) {
            var url = request.get('links').get('appointment-request-messages')
                .get('href');
            var attributes = {
                messageText: message,
                AppointmentRequestId: request.get('dataIdentifier').uniqueId,
                senderId: userId,
            };
            var options = {
                url: url,
                success: _.bind(this.onSuccess, this),
            };
            return this.save(attributes, options);
        },

        onSuccess: function() {
            this.trigger('save:success');
        },
    });
});
